#include "CubeCiel.h"

#include "texture.h"

CCubeCiel::CCubeCiel()
{
 texId=0xFFFFFFFF;
 cube=0xFFFFFFFF;
}

CCubeCiel::~CCubeCiel(){clear();}

void CCubeCiel::makeCube(float c)
{
 if(cube!=0xFFFFFFFF)glDeleteLists(cube,1);
 cube=glGenLists(1);
 
 glNewList(cube, GL_COMPILE);
 
 glColor3f(1.0,1.0,1.0);
 
 /*
 glVertex3f(-c,c,-c);//1
 glVertex3f(c,c,-c);//2
 glVertex3f(-c,-c,-c);//3
 glVertex3f(c,-c,-c);//4
 
 glVertex3f(-c,c,c);//5
 glVertex3f(c,c,c);//6
 glVertex3f(-c,-c,c);//7
 glVertex3f(c,-c,c);//8
 
 glTexCoord2f(0.0,0.0);
 */
 
 glBegin(GL_QUADS);

 glTexCoord2f(0.5,0.0);glVertex3f(c,c,-c);//2
 glTexCoord2f(0.5,1.0);glVertex3f(c,c,c);//6
 glTexCoord2f(0.0,1.0);glVertex3f(-c,c,c);//5
 glTexCoord2f(0.0,0.0);glVertex3f(-c,c,-c);//1
 
 glEnd();
 
 glBegin(GL_QUAD_STRIP);
 
 glTexCoord2f(0.01,0.0);glVertex3f(-c,c,-c);//1
 glTexCoord2f(0.01,1.0);glVertex3f(-c,-c,-c);//3
 glTexCoord2f(0.5,0.0);glVertex3f(c,c,-c);//2
 glTexCoord2f(0.5,1.0);glVertex3f(c,-c,-c);//4
 glTexCoord2f(0.99,0.0);glVertex3f(c,c,c);//6
 glTexCoord2f(0.99,1.0);glVertex3f(c,-c,c);//8
 glTexCoord2f(0.5,0.0);glVertex3f(-c,c,c);//5
 glTexCoord2f(0.5,1.0);glVertex3f(-c,-c,c);//7
 glTexCoord2f(0.01,0.0);glVertex3f(-c,c,-c);//1
 glTexCoord2f(0.01,1.0);glVertex3f(-c,-c,-c);//3
 
 glEnd();
 
 glBegin(GL_QUADS);
 
 glTexCoord2f(0.5,0.0);glVertex3f(-c,-c,-c);//3
 glTexCoord2f(0.5,1.0);glVertex3f(-c,-c,c);//7
 glTexCoord2f(1.0,1.0);glVertex3f(c,-c,c);//8
 glTexCoord2f(1.0,0.0);glVertex3f(c,-c,-c);//4
 
 glEnd();
 
 glEndList();
}

char *texturesCiel[4]=
{
     ".\\Media\\Ciel1.bmp",
     ".\\Media\\Ciel2.bmp",
     ".\\Media\\Ciel3.bmp",
     ".\\Media\\Ciel4.bmp"
};

void CCubeCiel::getTexture()
{
 srand((time_t)time(NULL));
 CTexture *pTexMgr = CTexture::GetInstance();
 texId=pTexMgr->getTexture(texturesCiel[rand()%4]);
}

void CCubeCiel::render(Vecteur &pCam)
{
 if(cube!=0xFFFFFFFF)
 {
  if(texId!=0xFFFFFFFF)
  {
   glEnable(GL_TEXTURE_2D);
   glBindTexture(GL_TEXTURE_2D, texId);
  }
  glPushMatrix();
  glTranslatef(pCam.x,pCam.y,pCam.z);
  glCallList(cube);
  glPopMatrix();
  glDisable(GL_TEXTURE_2D);
 }
}

void CCubeCiel::render()
{
 if(cube!=0xFFFFFFFF)
 {
  if(texId!=0xFFFFFFFF)
  {
   glEnable(GL_TEXTURE_2D);
   glBindTexture(GL_TEXTURE_2D, texId);
  }
  glCallList(cube);
  if(texId!=0xFFFFFFFF)glDisable(GL_TEXTURE_2D);
 }
}

void CCubeCiel::clear()
{
 if(cube!=0xFFFFFFFF)glDeleteLists(cube,1);
 texId=0xFFFFFFFF;
 cube=0xFFFFFFFF;
}
